RequireSystemScript("input.js");

RequireScript("flik_menu.js");
RequireScript("Piece.js");
RequireScript("BrickBoard.js");
RequireScript("Keys.js");
RequireScript("KeyHandler.js");
RequireScript("Menu.js");
RequireScript("Level.js");
RequireScript("text_wrap.js");
RequireScript("Controls.js");
RequireScript("Highscores.js");

const SCREENWIDTH  = GetScreenWidth();
const SCREENHEIGHT = GetScreenHeight();
const FONT         = LoadFont("Default.rfn");
const WINDOW       = LoadWindowStyle("Menu.rws");
const WHITE        = CreateColor(255, 255, 255);
const GOLD         = CreateColor(255, 204, 0);
const BACKGROUND   = LoadImage("Background.png");
const ARROW        = LoadImage("Arrow.png");
const ARROWMENU    = LoadImage("ArrowMenu.png");
const LOGO         = LoadImage("Logo.png");
const SPHERICAL    = LoadImage("Spherical.png");
const THREECOUNT   = LoadImage("3Count.png");
const TWOCOUNT     = LoadImage("2Count.png");
const ONECOUNT     = LoadImage("1Count.png");
const HPIMG        = LoadImage("HP.png");
const TETRISATTACK = LoadSound("Tetris_Attack_Final_Panic_OC_ReMix.mp3", true);

// FACES
const EARLNEUTRAL        = LoadImage("EarlNeutral.png");
const EARLSKEPTICAL      = LoadImage("EarlSkeptical.png");
const EARLAMUSED         = LoadImage("EarlAmused.png");
const EARLSERIOUS        = LoadImage("EarlSerious.png");

const RIPPERANGRY        = LoadImage("RipperAngry.png");
const RIPPERBEATEN       = LoadImage("RipperBeaten.png");
const RIPPERHAPPY        = LoadImage("RipperHappy.png");

const GIRDERANGRY        = LoadImage("GirderAngry.png");
const GIRDERSAD          = LoadImage("GirderSad.png");
const GIRDERHAPPY        = LoadImage("GirderHappy.png");

const ROSENEUTRAL        = LoadImage("RoseNeutral.png");
const ROSEFLIRTING       = LoadImage("RoseFlirting.png");
const ROSEANGRY          = LoadImage("RoseAngry.png");

const PASCALNEUTRAL      = LoadImage("PascalNeutral.png");
const PASCALHAPPY        = LoadImage("PascalHappy.png");
const PASCALANGRY        = LoadImage("PascalAngry.png");

const JESSNEUTRAL        = LoadImage("JessNeutral.png");
const JESSHURT           = LoadImage("JessHurt.png");
const JESSHAPPY           = LoadImage("JessHappy.png");

const CREAZYHAPPY        = LoadImage("CreazyHappy.png");
const CREAZYNEUTRAL      = LoadImage("CreazyNeutral.png");
const CREAZYHURT         = LoadImage("CreazyHurt.png");

const BLACKNEUTRAL       = LoadImage("BlackNeutral.png");
const BLACKHURT          = LoadImage("BlackHurt.png");
const BLACKHAPPY         = LoadImage("BlackHappy.png");

const DUSKNEUTRAL       = LoadImage("DuskNeutral.png");
const DUSKHURT          = LoadImage("DuskHurt.png");
const DUSKHAPPY         = LoadImage("DuskHappy.png");

var Score = 0;
var HSNames = [];
var HSScores = [];

function game() {
	// get controls if available
	var file = OpenFile("Controls.sav");
	for(var key in Keys) {
		Keys[key] = file.read(key, Keys[key]);
	}
	// if there are no highscores then save defaults
	var file = OpenFile("Highscores.sav");
	HSNames.push(file.read("NAME1", "UB3R 1337 G4M3R"));
	HSScores.push(file.read("SCORE1", 1500000));
	HSNames.push(file.read("NAME2", "The above person is an idiot."));
	HSScores.push(file.read("SCORE2", 1499999));
	HSNames.push(file.read("NAME3", "lol stfu your a n00b!!1"));
	HSScores.push(file.read("SCORE3", 1000000));
	HSNames.push(file.read("NAME4", "Dusk"));
	HSScores.push(file.read("SCORE4", 500000));
	HSNames.push(file.read("NAME5", "Black"));
	HSScores.push(file.read("SCORE5", 300000));
	HSNames.push(file.read("NAME6", "Creazy"));
	HSScores.push(file.read("SCORE6", 100000));
	HSNames.push(file.read("NAME7", "Jess"));
	HSScores.push(file.read("SCORE7", 50000));
	HSNames.push(file.read("NAME8", "Pascal"));
	HSScores.push(file.read("SCORE8", 30000));
	HSNames.push(file.read("NAME9", "Rose"));
	HSScores.push(file.read("SCORE9", 10000));
	HSNames.push(file.read("NAME10", "Ripper and Girder"));
	HSScores.push(file.read("SCORE10", 5000));
	file.close();
	
	var fadeColor = CreateColor(0, 0, 0);
	var time = GetTime();
	// wait
	while(time + 1000 > GetTime()) {
		ApplyColorMask(fadeColor);
		FlipScreen();
	}
	// fade in
	time = GetTime();
	while(time + 250 > GetTime()) {
		SPHERICAL.blit(0, 0);
		ApplyColorMask(fadeColor);
		fadeColor.alpha = 255 - 255 * (GetTime() - time) / 250;
		FlipScreen();
	}
	// wait
	time = GetTime();
	while(time + 1500 > GetTime()) {
		SPHERICAL.blit(0, 0);
		FlipScreen();
	}
	// fade out
	time = GetTime();
	while(time + 250 > GetTime()) {
		SPHERICAL.blit(0, 0);
		ApplyColorMask(fadeColor);
		fadeColor.alpha = 255 * (GetTime() - time) / 250;
		FlipScreen();
	}
	
	TETRISATTACK.play(true);
	MainMenu.run();
}

function Create2DArray(x, y) {
	var arr = new Array(x);
	for(var i = 0; i < x; i++) {
		arr[i] = new Array(y);
		for(var j = 0; j < y; j++) {
			arr[i][j] = NOBLOCK;
		}
	}
	return arr;
}

function CreateBoardKeys() {
	KeyHandler.add(Keys.ROTATERIGHT, ONKEYDOWN, function() {
		CurrentBoard.rotateRight();
	});
	
	KeyHandler.add(Keys.ROTATELEFT, ONKEYDOWN, function() {
		CurrentBoard.rotateLeft();
	});
	
	KeyHandler.add(Keys.DOWN, ONKEYPRESS, function() {
		CurrentBoard.moveCurrentPieceDown();
	});
	
	KeyHandler.add(Keys.FALL, ONKEYDOWN, function() {
		CurrentBoard.moveCurrentPieceFall();
	});
	
	KeyHandler.add(Keys.LEFT, ONKEYPRESS, function() {
		CurrentBoard.moveCurrentPieceLeft();
	});
	
	KeyHandler.add(Keys.RIGHT, ONKEYPRESS, function() {
		CurrentBoard.moveCurrentPieceRight();
	});
	
	KeyHandler.add(Keys.PAUSE, ONKEYUP, function() {
		CurrentBoard.pause();
	});
}

var CurrentBoard;

function DrawText(x, y, text) {
	FONT.drawText(x, y, text);
}

function DrawTextBox(x, y, w, h, text) {
	WINDOW.drawWindow(x, y, w, h);
	FONT.drawTextBox(x, y, w, h, 0, text);
}

function EatKey() {
	while(IsAnyKeyPressed()) {}
	while(AreKeysLeft()) GetKey();
}

function AcceptKey() {
	while(GetKey() != Keys.ACCEPT) {}
}

function Message(text, imgSpeaker) {
	var index = 0;
	text = ToLongString(WordWrapByFontWidth(text, FONT, 260));
	while(index++ < text.length && !IsKeyPressed(Keys.ACCEPT)) {
		if(IsKeyPressed(Keys.CANCEL))
			return;
		BACKGROUND.blit(0, 0);
		DrawTextBox(30, 150, 260, 60, text.substring(0, index));
		if(typeof imgSpeaker == "object") {
			imgSpeaker.blit(135, 100);
		}
		FlipScreen();
		Delay(10);
	}
	EatKey();
	var time = GetTime();
	while(!IsKeyPressed(Keys.ACCEPT)) {
		if(IsKeyPressed(Keys.CANCEL))
			return;
		BACKGROUND.blit(0, 0);
		DrawTextBox(30, 150, 260, 60, text);
		if(typeof imgSpeaker == "object") {
			imgSpeaker.blit(135, 100);
		}
		if(Math.sin((GetTime() - time)>>7) > 0)
			ARROW.blit(155, 210);
		FlipScreen();
	}
	EatKey();
}

function Pause(ms) {
	BACKGROUND.blit(0, 0);
	FlipScreen();
	Delay(ms);
	EatKey();
}

function GetName() {
	EatKey();
	BACKGROUND.blit(0, 0);
	WINDOW.drawWindow(75, 100, 170, 30);
	DrawText(75, 100, "Please enter your name:");
	return GetString(75, 115, FONT, 20);
}

function ContinueMenu() {
	var cont = false;
	CurrentBoard.blit();
	ApplyColorMask(CreateColor(0, 0, 0, 128));
	WINDOW.drawWindow(75, 100, 170, 45);
	DrawText(75, 100, "Would you like to continue?");
	var img = GrabImage(0, 0, 320, 240);
	
	var mm = new Menu(75, 114, 90, 30);
	mm.addDefaultKeys(Keys.UP, Keys.DOWN, Keys.LEFT, Keys.RIGHT, Keys.ACCEPT, Keys.CANCEL);
	//mm.setWindowStyle(WINDOW);
	mm.setArrow(ARROWMENU);
	mm.addText("Yes", function() {
		cont = true;
		mm.escape_function();
	}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
	mm.addText("No", function() {
		mm.escape_function();
	}, FONT, CreateColor(255, 255, 255), CreateColor(255, 204, 0));
	
	mm.preRender = function() {
		img.blit(0, 0);
	}
	mm.execute();
	
	return cont;
}